/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.lspeed.LsViewSelectionHandler;
import ibm.nways.lspeed.LsViewSelectionSection;
import ibm.nways.lspeed.LsViewSelectionWidget;
import ibm.nways.lspeed.RmonContextName;
import ibm.nways.lspeed.eui.RmonLaunchBasePanel;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class RmonLaunchPanel
extends RmonLaunchBasePanel
implements LsViewSelectionHandler {
    private static String HelpDirName = "ibm.nways.lspeed.eui";
    private static String HelpDocName = "ibm.nways.lspeed.eui.RmonLaunchBasePanel.html";
    private HelpRef helpRef = new HelpRef(HelpDirName, HelpDocName);
    protected Properties properties;
    protected static final String PropertiesFile = "properties/BrowserApplet.txt";
    static final String NT = "Windows NT";
    String os;
    String binDirName;
    private static String bundleName = "ibm.nways.lspeed.LsRmonResources";
    private static ResourceBundle LsRmonResources = null;
    private Integer slot;
    private Integer subSlot;
    private SnmpContextModel contextModel;
    private ModelInfo config;
    boolean pathgood = false;
    public boolean loggingOn = false;
    String inPath;
    GenModel Device_model;
    GenModel LsRmonTable_model;
    LsViewSelectionSection LsViewSelectionPropertySection;

    public Integer getSlot() {
        return this.slot;
    }

    public void setSlot(Integer n) {
        this.slot = n;
    }

    public Integer getSubSlot() {
        if (this.subSlot == null) {
            this.subSlot = new Integer(1);
        }
        return this.subSlot;
    }

    public ModelInfo getConfig() {
        return this.config;
    }

    public ModelInfo getLsRmonGenInfoInfo() {
        return this.LsRmonGenInfoInfo;
    }

    public RmonLaunchPanel() {
        this.setHelpRef(this.helpRef);
        LsRmonResources = ResourceBundle.getBundle(bundleName);
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (RmonLaunchBasePanel.myResources == null) {
            return string;
        }
        try {
            return RmonLaunchBasePanel.myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected void getModels() {
        JdmBrowser jdmBrowser = (JdmBrowser)this.getBrowser();
        if (this.Device_model == null) {
            this.Device_model = (GenModel)jdmBrowser.getModel();
        }
        this.displayMsg(RmonLaunchPanel.getNLSString("accessDataMsg"));
        String string = jdmBrowser.getParameter("startLogging");
        if (string != null && string.equals("true")) {
            this.loggingOn = true;
        }
        System.out.println("RmonLaunchPanel: loggingOn is " + this.loggingOn);
        this.os = System.getProperty("os.name");
        try {
            ModelInfo modelInfo;
            if (this.LsRmonTable_model == null) {
                this.LsRmonTable_model = (GenModel)this.Device_model.getComponent("LsRmonTable");
                modelInfo = this.LsRmonTable_model.getNextInfo("_Empty", "default", null);
                if (modelInfo != null && modelInfo.get("Index.Slot") instanceof Integer && modelInfo.get("Index.SubSlot") instanceof Integer) {
                    this.setSlot((Integer)modelInfo.get("Index.Slot"));
                }
            }
            modelInfo = new ModelInfo();
            modelInfo.add("Index.Slot", this.getSlot());
            modelInfo.add("Index.SubSlot", this.getSubSlot());
            GenModel genModel = this.LsRmonTable_model.getRowRef(modelInfo);
            GenModel genModel2 = (GenModel)genModel.getComponent("LsRmonAgent");
            this.LsRmonInterfaces_model = (GenModel)genModel2.getComponent("LsRmonInterfaces");
            this.contextModel = (SnmpContextModel)this.Device_model.getComponent("_ContextInfo");
            this.config = this.contextModel.getConfig();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected void addRmonIDSection() {
        this.LsViewSelectionPropertySection = new LsViewSelectionSection(this);
        this.LsViewSelectionPropertySection.layoutSection();
        this.addSection(RmonLaunchPanel.getNLSStringRmon("RmonSlotSection"), this.LsViewSelectionPropertySection);
        if (!this.os.equals(NT)) {
            this.getProperties();
        }
        super.addRmonIDSection();
    }

    protected void addRmonLaunchDetailsSection() {
        this.RmonLaunchDetailsPropertySection = new RmonLaunchDetailsSectionEx();
        this.RmonLaunchDetailsPropertySection.layoutSection();
        this.addSection(RmonLaunchPanel.getNLSString("RmonLaunchDetailsSectionTitle"), this.RmonLaunchDetailsPropertySection);
    }

    public void setSelectedView(Integer n) {
        this.setSlot(n);
        this.getModels();
        this.RmonLaunchTableIndex = 0;
        this.RmonLaunchTableData.removeAllElements();
        this.reset();
    }

    public Integer getSelectedView() {
        return this.getSlot();
    }

    public String getViewSelectionName() {
        return RmonLaunchPanel.getNLSStringRmon("RmonSlotSectionLabel");
    }

    public void addViews(LsViewSelectionWidget lsViewSelectionWidget) {
        Vector vector = null;
        try {
            vector = this.LsRmonTable_model.getRestOfInfo("RmonTableEntry", "default", null, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                int n2;
                ModelInfo modelInfo = (ModelInfo)vector.elementAt(n);
                Serializable serializable = modelInfo.get("Index.Slot");
                Serializable serializable2 = modelInfo.get("RmonTableEntry.ModVersion");
                Serializable serializable3 = modelInfo.get("RmonTableEntry.ModTypeOne");
                if (this.loggingOn) {
                    System.out.println(" Modversion=" + serializable2 + "  ModTypeone=" + serializable3);
                }
                boolean bl = true;
                if (serializable3 instanceof Integer) {
                    n2 = (Integer)serializable3;
                    switch (n2) {
                        case 1: {
                            bl = false;
                            break;
                        }
                        case 3: {
                            bl = false;
                            break;
                        }
                        case 5: {
                            bl = false;
                            break;
                        }
                        case 6: {
                            bl = false;
                            break;
                        }
                        case 10: {
                            bl = false;
                            break;
                        }
                    }
                }
                n2 = 1;
                if (!bl && serializable2 instanceof String && ((String)((Object)serializable2)).indexOf("v1") > -1) {
                    n2 = 0;
                }
                if (serializable != null && serializable instanceof Integer && n2 != 0) {
                    lsViewSelectionWidget.addSelection((Integer)serializable, null);
                }
                ++n;
            }
        }
    }

    public void getProperties() {
        this.pathgood = false;
        try {
            BrowserApplet browserApplet = this.getBrowser();
            URL uRL = new URL(browserApplet.getDocumentBase(), PropertiesFile);
            if (this.loggingOn) {
                System.out.println("RmonLaunchPanel:DocumentBase = " + browserApplet.getDocumentBase());
                System.out.println(" url " + uRL);
            }
            this.properties = new Properties();
            this.properties.load(uRL.openStream());
            this.binDirName = this.os.equals(NT) ? (String)((Hashtable)this.properties).get("ntNwaysBinDir") : (String)((Hashtable)this.properties).get("aixNwaysBinDir");
            if (!this.binDirName.equals(null)) {
                this.binDirName = this.trimQuotes(this.binDirName);
                this.pathgood = true;
            }
            if (this.loggingOn) {
                System.out.println("RmonLaunchPanel: properties get of bindirname = " + this.binDirName);
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("Error getting RmonLaunch Properties : " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private String trimQuotes(String string) {
        String string2 = string;
        if (string2 != null && string2.trim() != null) {
            int n;
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("\"") && (n = string2.lastIndexOf("\"")) != -1) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    protected static String getNLSStringRmon(String string) {
        if (LsRmonResources == null) {
            return string;
        }
        try {
            return LsRmonResources.getString(string);
        }
        catch (Exception exception) {
            System.out.println(" LsRmonResource error ");
            return string;
        }
    }

    public class RmonLaunchDetailsSectionEx
    extends RmonLaunchBasePanel.RmonLaunchDetailsSection {
        MessageBox messageToUser;
        ModelInfo LsRmonGenInfoInfoIn;
        private Process pathchild;
        private Process launchchild;
        private ModelInfo config;

        public void layoutSection() {
            super.layoutSection();
            int n = 99;
            String[] stringArray = new String[3];
            if (RmonLaunchPanel.this.os.equals(RmonLaunchPanel.NT)) {
                stringArray[0] = "cmd.exe";
                stringArray[1] = "/c echo";
                stringArray[2] = "Remon:%lansentry%";
            } else {
                stringArray[0] = "sh";
                stringArray[1] = String.valueOf(RmonLaunchPanel.this.binDirName) + "nwysrfp.ksh";
            }
            try {
                this.pathchild = Runtime.getRuntime().exec(stringArray);
                int n2 = 0;
                int n3 = 15;
                while (n2++ < n3 && n == 99) {
                    System.out.println("RmonLaunchPanel: Getting Path");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    try {
                        n = this.pathchild.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        if (n2 <= n3 - 1) continue;
                        n = 4;
                        if (!RmonLaunchPanel.this.loggingOn) continue;
                        System.out.println("RmonLaunchPanel: GetPath taking too long to complete");
                    }
                }
                if (n == 0) {
                    n = this.getpath();
                }
            }
            catch (Exception exception) {
                System.out.println("RmonLaunchPanel error:" + exception);
                n = 4;
            }
            if (n == 0) {
                RmonLaunchPanel.this.pathgood = true;
            } else {
                RmonLaunchPanel.this.pathgood = false;
                RmonLaunchPanel.this.inPath = RmonLaunchPanel.getNLSStringRmon("notfound");
            }
            if (n == 1) {
                this.messageToUser = new MessageBox(RmonLaunchPanel.this.getBrowser().getFrame(), RmonLaunchPanel.getNLSStringRmon("Launcherror"), RmonLaunchPanel.getNLSStringRmon("RM_PFpathnotfound"), true);
            }
            if (n > 1) {
                this.messageToUser = new MessageBox(RmonLaunchPanel.this.getBrowser().getFrame(), RmonLaunchPanel.getNLSStringRmon("Launcherror"), RmonLaunchPanel.getNLSStringRmon("RM_unknownerrorPF"), true);
            }
        }

        public int getpath() {
            int n = -1;
            int n2 = 4;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.pathchild.getInputStream()));
                String string = bufferedReader.readLine();
                if (RmonLaunchPanel.this.loggingOn) {
                    System.out.println("RmonLaunchPanel:  buffered line = " + string);
                }
                while (string != null) {
                    n = string.indexOf(":");
                    if (n != -1) {
                        RmonLaunchPanel.this.inPath = string.substring(n + 1, string.length()).trim();
                        n2 = RmonLaunchPanel.this.inPath.length() == 0 ? 1 : 0;
                    }
                    string = bufferedReader.readLine();
                    if (!RmonLaunchPanel.this.loggingOn) continue;
                    System.out.println("RmonLaunchPanel:  buffered line = " + string);
                }
            }
            catch (Exception exception) {
                System.out.println("RmonLaunchPanel error:" + exception);
                n2 = 4;
            }
            if (RmonLaunchPanel.this.loggingOn) {
                System.out.println("RmonLaunchPanel:  path of ReMon = " + RmonLaunchPanel.this.inPath);
            }
            return n2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void apply() {
            int n;
            boolean bl;
            String[] stringArray;
            block27: {
                block28: {
                    stringArray = new String[8];
                    bl = false;
                    boolean bl2 = false;
                    this.LsRmonGenInfoInfoIn = RmonLaunchPanel.this.getLsRmonGenInfoInfo();
                    n = 99;
                    String string = "viewport";
                    String string2 = null;
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    if (RmonLaunchPanel.this.loggingOn) {
                        System.out.println("RmonLaunchPanel: section apply started");
                    }
                    if (!this.validateSection()) break block28;
                    RmonLaunchPanel.this.inPath = (String)((Object)this.getrmonLaunchPathField());
                    RmonLaunchPanel.this.inPath = RmonLaunchPanel.this.inPath.trim();
                    this.LsRmonGenInfoInfoIn.add("LsRmonGenInfo.RmonLaunchPath", this.getrmonLaunchPathField());
                    string4 = this.config.get("Config.Address").toString();
                    string2 = String.valueOf(string4) + ".Module_" + RmonLaunchPanel.this.getSlot();
                    string5 = this.config.get("Config.WriteCommName").toString();
                    string5 = String.valueOf(string5) + RmonContextName.getRmonAgentExt() + RmonLaunchPanel.this.getSlot();
                    string3 = "if:" + (String)((Object)this.getifIndexField());
                    if (RmonLaunchPanel.this.os.equals(RmonLaunchPanel.NT)) {
                        bl2 = true;
                        stringArray[0] = "cmd.exe /c start";
                        stringArray[1] = "/d" + RmonLaunchPanel.this.inPath;
                        stringArray[2] = "RMONSTRT";
                        stringArray[3] = string;
                        stringArray[4] = string2;
                        stringArray[5] = string3;
                        stringArray[6] = string4;
                        stringArray[7] = string5;
                        if (this.checkNTpath(RmonLaunchPanel.this.inPath)) {
                            bl = true;
                        } else {
                            RmonLaunchPanel.this.pathgood = false;
                            n = 4;
                        }
                        if (RmonLaunchPanel.this.loggingOn) {
                            System.out.println("RmonLaunchPanel:  cmdarray for lauching ReMon");
                            System.out.println("==============================================");
                            System.out.println("Start cmd     (cmdArray[0])= " + stringArray[0]);
                            System.out.println("start path    (cmdArray[1])= " + stringArray[1]);
                            System.out.println("rmonstart cmd (cmdArray[2])= " + stringArray[2]);
                            System.out.println("application   (cmdArray[3])= " + stringArray[3]);
                            System.out.println("probe name    (cmdArray[4])= " + stringArray[4]);
                            System.out.println("interface     (cmdArray[5])= " + stringArray[5]);
                            System.out.println("ip address    (cmdArray[6])= " + stringArray[6]);
                            System.out.println("community name(cmdArray[7])= " + stringArray[7]);
                            System.out.println("  should launch = " + bl);
                        }
                    }
                    if (!bl2) {
                        stringArray[0] = "sh";
                        stringArray[1] = String.valueOf(RmonLaunchPanel.this.inPath) + "/rmon";
                        stringArray[2] = string;
                        stringArray[3] = string2;
                        stringArray[4] = string3;
                        stringArray[5] = string4;
                        stringArray[6] = string5;
                        bl = true;
                        if (RmonLaunchPanel.this.loggingOn) {
                            System.out.println("RmonLaunchPanel:  cmdarray for lauching ReMon");
                            System.out.println("==============================================");
                            System.out.println("shell         (cmdArray[0])= " + stringArray[0]);
                            System.out.println("path + /rmon  (cmdArray[1])= " + stringArray[1]);
                            System.out.println("applicaton    (cmdArray[2])= " + stringArray[2]);
                            System.out.println("probename     (cmdArray[3])= " + stringArray[3]);
                            System.out.println("interface     (cmdArray[4])= " + stringArray[4]);
                            System.out.println("ipaddress     (cmdArray[5])= " + stringArray[5]);
                            System.out.println("communityname (cmdArray[6])= " + stringArray[6]);
                        }
                    }
                    if (bl) {
                        n = -1;
                        try {
                            RmonLaunchPanel.this.displayMsg(RmonLaunchPanel.getNLSStringRmon("startRmonLaunch"));
                            this.launchchild = Runtime.getRuntime().exec(stringArray);
                            int n2 = 0;
                            int n3 = 15;
                            while (n2++ < n3 && n == -1) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {}
                                try {
                                    n = this.launchchild.exitValue();
                                }
                                catch (IllegalThreadStateException illegalThreadStateException) {
                                    if (n2 <= n3 - 1) continue;
                                    n = 5;
                                    if (!RmonLaunchPanel.this.loggingOn) continue;
                                    System.out.println("RmonLaunchPanel: Launch taking too long to complete");
                                }
                            }
                            break block27;
                        }
                        catch (Exception exception) {
                            System.out.println("RmonLaunchPanel error launching Remote Monitor:" + exception);
                            n = 2;
                            bl = false;
                        }
                    }
                    break block27;
                }
                RmonLaunchPanel.this.inPath = (String)((Object)this.getrmonLaunchPathField());
                n = 3;
            }
            if (!bl && n > 0) {
                RmonLaunchPanel.this.displayMsg(RmonLaunchPanel.getNLSStringRmon("noRmonLaunch"));
            }
            if (RmonLaunchPanel.this.loggingOn) {
                System.out.println("RmonLaunchPanel:  rc on launch = " + n);
            }
            switch (n) {
                case 0: {
                    RmonLaunchPanel.this.displayMsg(RmonLaunchPanel.getNLSStringRmon("RM_launched"));
                    return;
                }
                case 1: {
                    MessageBox messageBox = new MessageBox(RmonLaunchPanel.this.getBrowser().getFrame(), RmonLaunchPanel.getNLSStringRmon("Launcherror"), RmonLaunchPanel.getNLSStringRmon("RM_rmnotfound"), true);
                    RmonLaunchPanel.this.displayMsg(RmonLaunchPanel.getNLSStringRmon("RM_rmnotfound"));
                    return;
                }
                case 2: {
                    MessageBox messageBox = new MessageBox(RmonLaunchPanel.this.getBrowser().getFrame(), RmonLaunchPanel.getNLSStringRmon("Launcherror"), String.valueOf(RmonLaunchPanel.getNLSStringRmon("RM_batnotfound")) + stringArray[0], true);
                    RmonLaunchPanel.this.displayMsg(RmonLaunchPanel.getNLSStringRmon("RM_batnotfound"));
                    return;
                }
                case 3: {
                    MessageBox messageBox = new MessageBox(RmonLaunchPanel.this.getBrowser().getFrame(), RmonLaunchPanel.getNLSStringRmon("Launcherror"), RmonLaunchPanel.getNLSStringRmon("RM_baddata"), true);
                    RmonLaunchPanel.this.displayMsg(RmonLaunchPanel.getNLSStringRmon("RM_baddata"));
                    return;
                }
                case 4: {
                    MessageBox messageBox = new MessageBox(RmonLaunchPanel.this.getBrowser().getFrame(), RmonLaunchPanel.getNLSStringRmon("Launcherror"), RmonLaunchPanel.getNLSStringRmon("RM_badpath"), true);
                    RmonLaunchPanel.this.displayMsg(RmonLaunchPanel.getNLSStringRmon("RM_badpath"));
                    return;
                }
                case 5: {
                    MessageBox messageBox = new MessageBox(RmonLaunchPanel.this.getBrowser().getFrame(), RmonLaunchPanel.getNLSStringRmon("Launcherror"), RmonLaunchPanel.getNLSStringRmon("RM_toolong"), true);
                    RmonLaunchPanel.this.displayMsg(RmonLaunchPanel.getNLSStringRmon("RM_toolong"));
                    return;
                }
                case 127: {
                    MessageBox messageBox = new MessageBox(RmonLaunchPanel.this.getBrowser().getFrame(), RmonLaunchPanel.getNLSStringRmon("Launcherror"), RmonLaunchPanel.getNLSStringRmon("RM_toolong"), true);
                    RmonLaunchPanel.this.displayMsg(RmonLaunchPanel.getNLSStringRmon("RM_toolong"));
                    return;
                }
                default: {
                    MessageBox messageBox = new MessageBox(RmonLaunchPanel.this.getBrowser().getFrame(), RmonLaunchPanel.getNLSStringRmon("Launcherror"), RmonLaunchPanel.getNLSStringRmon("RM_unknownerror"), true);
                    RmonLaunchPanel.this.displayMsg(RmonLaunchPanel.getNLSStringRmon("RM_unknownerror"));
                    return;
                }
                case 72: 
            }
        }

        public boolean checkNTpath(String string) {
            if (string.indexOf(":") != 1) {
                return false;
            }
            return string.indexOf(" ") <= -1;
        }

        public boolean validateSection() {
            try {
                new Integer((String)((Object)this.getifIndexField()));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (!this.validatermonLaunchPathField()) {
                return false;
            }
            if (!RmonLaunchPanel.this.pathgood) {
                if (RmonLaunchPanel.this.inPath.equals(this.getrmonLaunchPathField())) {
                    return false;
                }
                RmonLaunchPanel.this.pathgood = true;
            }
            if (this.config == null) {
                if (RmonLaunchPanel.this.loggingOn) {
                    System.out.println("RmonLaunchPanel:validateSection - ipaddress and community name not found");
                }
                return false;
            }
            if (RmonLaunchPanel.this.loggingOn) {
                System.out.println("RmonLaunchPanel:validateSection - all data valid");
            }
            return true;
        }

        public void reset() {
            this.LsRmonGenInfoInfoIn = RmonLaunchPanel.this.getLsRmonGenInfoInfo();
            this.LsRmonGenInfoInfoIn.add("LsRmonGenInfo.RmonLaunchPath", (Serializable)((Object)RmonLaunchPanel.this.inPath));
            super.reset();
        }

        public RmonLaunchDetailsSectionEx() {
            RmonLaunchPanel.this = RmonLaunchPanel.this;
            this.config = RmonLaunchPanel.this.getConfig();
        }
    }
}

